*This takes the main file and transforms it backs into a panel data set that 
*can be used for the difference in difference specifications

cd "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files"
use "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\temp_prom.dta", clear
keep if main ==1 

*keep the relavant varaibles						
keep parti_in age_n4   age_mar_n4 wage_inc_real_n4 wage_inc_real_p_n4   ter_ed_n4 age_p_n4   ter_ed_p_n4  mar_length_n4 sec_mar_n4 same_eth_n4  ///
age_0 samp_full_kso samp_maj_kso main_maj samp_full_ main_np age_mar_0 wage_inc_real_0 wage_inc_real_p_0   ter_ed_0 age_p_0   ter_ed_p_0 est_prev  mar_length_0 sec_mar_0  same_eth_0	 ///
typeald*   typec_1 typec_2 close_* typeam_1 typeam_2 treat main close wage_inc_real_* parentaldays_* div_*   age_*  ///
rem_mar1* rem_mar2* rem_mar3* rem_mar4* rem_mar5* rem_mar6* rem_mar7*    mar_* woman p_id  typeatempt* typetempt* samp_parl electionperiod  typepar_1 typepar_2 typel_1 typel_2 typel_3  typeage_1 typeage_2 typeage_3 
gen w_ch= wage_inc_real_ch 
gen w_relch= wage_inc_real_relch
 gen w_hrelch= wage_inc_real_hrelch
  
 foreach var in w_ch w_relch w_hrelch{
	bysort woman: egen `var'_med=median( `var') if treat==1
	gen `var'_amedtr=treat==1 & `var'>=`var'_med if `var'!=.
	drop `var'_med
  }
  
 drop wage_inc_real_mean-wage_inc_real_hrelch 
 gen agec=age_n4

 *create a dataset with the relavant control variables
 preserve

keep parti_in p_id electionperiod age_n4   age_mar_n4 wage_inc_real_n4 wage_inc_real_p_n4  wage_inc_real_n1 wage_inc_real_p_n1  ///
wage_inc_real_1 wage_inc_real_p_1   ter_ed_n4 age_p_n4   ter_ed_p_n4  mar_length_n4 sec_mar_n4 same_eth_n4 ///
age_0   age_mar_0 wage_inc_real_0 wage_inc_real_p_0   ter_ed_0 age_p_0   ter_ed_p_0  mar_length_0 sec_mar_0 same_eth_0 	 

foreach year in n4 n1 0 1{
gen wage_pos_`year'= wage_inc_real_`year'>wage_inc_real_p_`year' if wage_inc_real_p_`year'!=. & wage_inc_real_`year'!=.
 gen wage_inc_real_share_`year'= wage_inc_real_`year'/(wage_inc_real_p_`year'+wage_inc_real_`year') if wage_inc_real_p_`year'!=. & wage_inc_real_`year'!=.
}
 gen age_diff_n4 = age_n4-age_p_n4
  gen age_diff_0 = age_0-age_p_0

 save cont_prom, replace
restore
*Reshape the data set to a panel data set based on time before and after the election
reshape long rem_mar1_@ rem_mar2_@  rem_mar3_@ rem_mar4_@ rem_mar5_@ rem_mar6_@ rem_mar7_@  age_@ wage_inc_real_@ ///
 wage_inc_real_p_@ mar_@ div_@ parentaldays_@ sick_pay_@ , i(  main close treat treat_alt samp_parl electionperiod p_id woman  ) j(t) string
 
**Create the main difference in difference variables and interaction with time diummies
*and sample and electionperiod dummies 
 keep if t!=""
foreach t in n6 n5 n4 n3 n2 n1 1 2 3 4 5 6 7 8 9 10{
	gen treat_`t' = treat==1 & t=="`t'"
}

foreach t in  n6 n5  n4 n3 n2 n1 1 2 3 4 5 6 7 8 9 10{
	gen td_`t' = t=="`t'"
}

foreach var in  samp_parl election{
	foreach t in  n6 n5  n4 n3 n2 n1 1 2 3 4 5 6 7 8 9 10{
		gen td_`t'_`var' =td_`t'*`var' 
	}
}

foreach t in  n6 n5   n4 n3 n2 n1 1 2 3 4 5 6 7 8 9 10{
	foreach year in 1991 1994 1998 2002 2006 2010{
		gen td_`t'_el`year' =td_`t'== 1 & electionperiod==`year' 
	}
}

replace t="-1" if t=="n1"
replace t="-2" if t=="n2"
replace t="-3" if t=="n3"
replace t="-4" if t=="n4"
replace t="-5" if t=="n5"
replace t="-6" if t=="n6"
destring t, replace force

egen p_id_el=group(p_id election)
gen main_wage= main==1 & age_ <65
gen wage_inc_real_g= wage_inc_real_/100 if age_<65
gen wage_inc_real_p_g= wage_inc_real_p_/100 if age_<65
gen ln_wage_inc_real_g= ln(wage_inc_real_)/100 if age_<65

*Dummy for sample of polticians that where married at four years prior to the election
gen main_mar= main==1 & rem_mar5_!=.  if wage_inc_real_!=.

gen year= electionperiod+t
drop if year>2014
*Add data on childring
joinby p_id year using "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\child_pprom.dta", unmatched(master)
drop _merge
gen child_dum_b=child_0_18_d if t==1
gen child06_dum_b=child_0_6_d if t==1
bysort p_id election: egen child_dum=max(child_dum_b)
bysort p_id election: egen child06_dum=max(child06_dum_b)

**Add the control varaibles

joinby p_id electionperiod using "cont_prom.dta", unmatched(master)

*Create interctions between treatment adn wage changes
gen pass= wage_pos_n1==0 & wage_pos_1==1 if wage_pos_n1!=. & wage_pos_1!=.
gen passtr= wage_pos_n1==0 & wage_pos_1==1 & treat==1 if wage_pos_n1!=. & wage_pos_1!=.
foreach var in  passtr w_ch_amedtr w_relch_amedtr w_hrelch_amedtr{
gen n_`var'=treat==1 & `var'==0
}

*Create interactions between time to election and control variables
foreach var in w_ch_amedtr w_relch_amedtr w_hrelch_amedtr pass passtr n_passtr   n_w_ch_amedtr n_w_relch_amedtr n_w_hrelch_amedtr ///
age_n4   age_mar_n4 wage_inc_real_n4 wage_pos_n4 wage_inc_real_p_n4 wage_inc_real_share_n4 ter_ed_n4 ter_ed_p_n4 age_p_n4 ///
 age_diff_n4    mar_length_n4 sec_mar_n4 same_eth_n4 ///
 age_0   age_mar_0 wage_inc_real_0 wage_pos_0 wage_inc_real_p_0 wage_inc_real_share_0 ter_ed_0 ter_ed_p_0 age_p_0 ///
 age_diff_0    mar_length_0 sec_mar_0 same_eth_0  {
	foreach t in n4 n3 n2 n1 1 2 3 4 5 6 7 8 9 10{
		gen td_`t'_`var' =td_`t'*`var' 
	}
}

*create dummy for being in the estimation sample for the first time
gen first=main==1 & est_prev!=1
*create male summy variable
gen man=woman==0
stop
